//
//  MPPopoverManager.h
//  Tonality
//
//  Created by Andrey on 6/10/14.
//  Copyright (c) 2014 MacPhun LLC. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum
{
    MPPopoverPositionLeft,
    MPPopoverPositionRight,
    MPPopoverPositionTop,
    MPPopoverPositionBottom,
    MPPopoverPositionCenter
} MPPopoverPosition;

typedef void(^MPPopoverManagerCloseHandler)(NSView *view);

__attribute__ ((deprecated("use 'MPPopoverViewController' instead.")))
@interface MPPopoverManager : NSObject

@property (nonatomic) BOOL popoverIsPresented;

- (void)showPopoverView:(NSView *)popoverView fromView:(NSView *)view withPosition:(MPPopoverPosition)position offset:(CGFloat)offset closeHandler:(MPPopoverManagerCloseHandler)closeHandler __attribute__ ((deprecated("use '-showPopoverView:fromView:withPosition:offset:skipEventMask:closeHandler:' instead.")));
- (void)showPopoverView:(NSView *)popoverView fromView:(NSView *)view withPosition:(MPPopoverPosition)position offset:(CGFloat)offset skipEventMask:(NSEventMask)mask closeHandler:(MPPopoverManagerCloseHandler)closeHandler;
- (void)showPopoverView:(NSView *)popoverView fromView:(NSView *)view withPosition:(MPPopoverPosition)position offset:(CGFloat)offset skipEventMask:(NSEventMask)mask shadowOffset:(NSPoint)shadowOffset closeHandler:(MPPopoverManagerCloseHandler)closeHandler;

- (void)dismissPopover;

+ (MPPopoverManager *)sharedManager;

@end
